<?php
include('./config.php');

// Handle file upload
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['csv_file'])) {
    $file = $_FILES['csv_file']['tmp_name'];

    if (($handle = fopen($file, 'r')) !== FALSE) {
        $inserted = 0;
        $skipped = 0;

        while (($data = fgetcsv($handle, 1000, ',')) !== FALSE) {
            $topic = trim($data[0]);

            if (!empty($topic)) {
                // Use prepared statement to avoid SQL injection
                $stmt = $conn->prepare("INSERT INTO blog_topics (topic) VALUES (?)");
                $stmt->bind_param("s", $topic);
                $stmt->execute();

                if ($stmt->affected_rows > 0) {
                    $inserted++;
                } else {
                    $skipped++;
                }

                $stmt->close();
            } else {
                $skipped++;
            }
        }

        fclose($handle);
        echo "<div style='padding:20px'><strong>Upload Completed.</strong><br>Inserted: $inserted<br>Skipped: $skipped</div>";
    } else {
        echo "Error opening file.";
    }
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Upload Topics CSV</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
  <div class="container mt-5">
    <div class="card shadow">
      <div class="card-header bg-primary text-white">
        <h4 class="mb-0">Upload Topics via CSV</h4>
      </div>
      <div class="card-body">
        <form action="" method="POST" enctype="multipart/form-data" id="csvUploadForm">
          <div class="mb-3">
            <label for="csvFile" class="form-label">Select CSV File</label>
            <input class="form-control" type="file" id="csvFile" name="csv_file" accept=".csv" required>
          </div>
          <button type="submit" class="btn btn-success">Upload</button>
        </form>
        <div id="responseMessage" class="mt-3"></div>
      </div>
    </div>
  </div>

  <script>
    // Optional: basic client-side validation
    document.getElementById('csvUploadForm').addEventListener('submit', function(e) {
      const fileInput = document.getElementById('csvFile');
      const file = fileInput.files[0];
      if (file && !file.name.endsWith('.csv')) {
        e.preventDefault();
        document.getElementById('responseMessage').innerHTML =
          '<div class="alert alert-danger">Please upload a valid .csv file.</div>';
      }
    });
  </script>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
