<?php 
error_reporting(E_ALL);
ini_set('display_errors', 'On');
include('config.php');

$fetch_topics = mysqli_query($conn, "SELECT `id`, `topic` FROM blog_topics WHERE `generated` = 0");

if (mysqli_num_rows($fetch_topics)) {
    $fetch_result = mysqli_fetch_assoc($fetch_topics);
        $id = $fetch_result['id'];
        $topic = $fetch_result['topic'];

        // Generate content
        $description = generateDescription($topic);
        $tags = generateTags($topic);
        $content = generateContent($topic);
}


?>
<!DOCTYPE html>
<html>
<head>
    <title>Generated Blog Content</title>
    <script src="https://cdn.jsdelivr.net/npm/marked/marked.min.js"></script>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 40px;
            background: #f9f9f9;
            color: #333;
        }
        h1, h2 {
            color: #0056b3;
        }
        .section {
            background: #fff;
            padding: 20px;
            margin-bottom: 30px;
            border-radius: 10px;
            box-shadow: 0 0 8px rgba(0,0,0,0.1);
        }
        .tags {
            background: #eef;
            padding: 10px;
            border-radius: 5px;
        }
        pre {
            white-space: pre-wrap;
        }
    </style>
    
</head>
<body>

    <h1>Generated Blog Content</h1>

    <div class="section">
        <h2>Topic</h2>
        <p><?php echo htmlspecialchars($topic); ?></p>
    </div>

    <div class="section">
        <h2>Description</h2>
        <div id="renderedDescription"></div>
        <script>
            const rawMarkdownDesc = <?php echo json_encode(htmlspecialchars_decode($description)); ?>;
            document.getElementById('renderedDescription').innerHTML = marked.parse(rawMarkdownDesc);
        </script>
    </div>

    <div class="section">
        <h2>Meta Tags</h2>
        <div class="tags">
            <p><?php echo cleanTags($tags); ?></p>
        </div>
    </div>

    <div class="section">
        <h2>Full Content</h2>
        <div id="renderedContent"></div>
        <script>
            const rawMarkdown = <?php echo json_encode(htmlspecialchars_decode($content)); ?>;
            document.getElementById('renderedContent').innerHTML = marked.parse(rawMarkdown);
        </script>
    </div>

</body>
</html>

<?php
function generateDescription($topic){
    return aiGeneration("Write a meta seo description in max 30 words on $topic and do not write anything except the description.");
}

function generateTags($topic){
    return aiGeneration("Generate 8 meta seo keywords seperated by comma on $topic. Do not write anything except the keywords.");
}

function generateContent($topic){
    return aiGeneration("Write about $topic in 1000 words");
}

function aiGeneration($prompt){
    $apiKey = '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'; // Replace with your real API key
    $apiKey = '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';
    $apiKey = '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';
    $apiKey='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';

    $url = 'https://openrouter.ai/api/v1/chat/completions';

    $data = [
        'model' => 'deepseek/deepseek-r1:free',
        'messages' => [
            ['role' => 'user', 'content' => $prompt]
        ]
    ];

    $headers = [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $apiKey
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $response = curl_exec($ch);
    curl_close($ch);

    $result = json_decode($response, true);

    if (isset($result['choices'][0]['message']['content'])) {
        return htmlspecialchars($result['choices'][0]['message']['content']);
    } elseif (isset($result['error']['message'])) {
        return "API Error: " . htmlspecialchars($result['error']['message']);
    } else {
        return "Unknown error occurred.";
    }
}

// Cleaning functions
function cleanDescription($text) {
    return preg_replace('/\(?\d+\s*words?\)?/', '', $text);
}

function cleanTags($text) {
    $text = strip_tags($text);
    $text = htmlspecialchars_decode($text); // decode any encoded characters
    $text = preg_replace('/\*\*?Keywords:?\*\*?\s*/i', '', $text); // remove Markdown-style "Keywords:"
    $text = preg_replace('/^(here are|keywords|formatted.*:)\s*/i', '', $text); // remove common AI prefixes
    return trim($text);
}

function cleanContent($text) {
    $text = preg_replace('/(?i)\*?By\s+\[.*?\]\*?/', '', $text); // Remove author
    $text = preg_replace('/(?i)\*?Word count:.*$/m', '', $text); // Remove word count

    // Markdown to HTML formatting
    $text = htmlspecialchars_decode($text);
    $text = preg_replace('/\*\*(.*?)\*\*/s', '<strong>$1</strong>', $text); // Bold
    $text = preg_replace('/\*(.*?)\*/s', '<em>$1</em>', $text);             // Italic
    $text = nl2br($text); // Line breaks to <br>
    
    return trim($text);
}
?>
