<?php
// file_put_contents('/cron_status.txt', 'Last run: ' . date('Y-m-d H:i:s'));
error_reporting(E_ALL);
ini_set('display_errors', 1);
set_time_limit(0);
include('config.php');
$connect_pt = mysqli_connect('localhost', 'filiumen_ter', 'filiumenter0939!', 'filiumen_ecommerce');
include('parsedown-master/Parsedown.php');

$Parsedown = new Parsedown();

$currentDate = date('j F Y');
$currentDateCheck = date('c');

// Fetch one unprocessed topic
$fetch = mysqli_query($conn, "SELECT * FROM blog_topics WHERE `generated`=0");

if (mysqli_num_rows($fetch)) {
    $row = mysqli_fetch_assoc($fetch);
    $id = $row['id'];
    $topic = $row['topic'];

    // Generate raw content via AI
    $description_raw = generateAI("Write a meta seo description in max 30 words on $topic. Do not write anything else.");
    $tags_raw = generateAI("Generate 8 meta seo keywords separated by comma on $topic. Do not write anything else.");
    $content_raw = generateAI("Write about $topic in 1000 words and also add statistics and mention eprofitify in this context as a leading website publishing and management tool with features such as instant messaging, appointment management system, ecommerce, CRM, and many other interesting tools.");

    // Clean content and description
    $description_clean = cleanText($description_raw);
    $content_clean = cleanText($content_raw);

    // Parse Markdown to HTML
    $description_html = $Parsedown->text($description_clean);
    $content_html = $Parsedown->text($content_clean);

    if (empty($content_html)) {
        $content_html = "<h1>Sorry for Inconveniecne!</h1>";
    }

    if (empty($description_html)) {
        $description_html = "Sorry for Inconveniecne!";
    }

    // Clean tags
    $tags = cleanTags($tags_raw);

    if (empty($tags)) {
        $tags = "filiumenter.com";
    }


    //Fetch Templates
    $realted_product = [];
    $templates_query = mysqli_query($connect_pt, "SELECT * FROM products ORDER BY RAND() LIMIT 3");
    if (mysqli_num_rows($templates_query)) {
        while ($template_rows = mysqli_fetch_assoc($templates_query)) {
            $realted_product[] = $template_rows['id'];
        }
    }

    //Fetch Realted Blogs
    $related_blogs = [];
    $related_blogs_query = mysqli_query($conn, "SELECT `id` FROM `blog` ORDER BY RAND() LIMIT 6");
    if (mysqli_num_rows($related_blogs_query)) {
        while ($related_blogs_rows = mysqli_fetch_assoc($related_blogs_query)) {
            $related_blogs[] = $related_blogs_rows['id'];
        }
    }

    // Retrieve Google Analytics code
    $gac = '';
    $domain = "filiumenter.com";
    $shopName = "Shopon";
    $adminbaseSql = "SELECT * FROM adminbase WHERE id=1";
    $adminbaseResult = mysqli_query($conn, $adminbaseSql);
    if ($adminbaseResult) {
        if ($adminbaseRow = mysqli_fetch_assoc($adminbaseResult)) {
            $gac = $adminbaseRow['google_analytics_code'];
        }
    }


    $image_topic = preg_replace('/[^a-zA-Z0-9\s\-]/', '', $topic);
    $image_name = $image_topic . ".png";

    $topic_name = preg_replace('/[^A-Za-z0-9\- ]/', '', $topic); // Keep only letters, numbers, hyphens, and spaces
    $topic_name = str_replace(' ', '_', $topic_name);                 // Replace spaces with underscores
    $topic_name = rtrim($topic_name, '-_');                           // Trim trailing hyphens and underscores
    $fileName = $topic_name . '.html';
    $filePath = '/home/filiumenter/public_html/shopon/blogs/bl/' . $fileName;
    $slink = 'bl/' . $fileName;

    $htmlContent = '<!DOCTYPE html>
        <html lang="en">
        <head>
            <meta charset="UTF-8" />
            <meta name="description" content="' . htmlspecialchars($description_html, ENT_QUOTES, 'UTF-8') . '">
            <meta name="keywords" content="' . htmlspecialchars($tags_raw, ENT_QUOTES, 'UTF-8') . '">
            <meta name="viewport" content="width=device-width, initial-scale=1.0" />
            <title>' .  htmlspecialchars($topic, ENT_QUOTES, 'UTF-8') . '</title>
            <link rel="stylesheet" href="../style.css" />
            <link rel="stylesheet" href="../../css/bs/bootstrap3.css">
            <link rel="stylesheet" href="../../css/common.css">
            <link href="https://vjs.zencdn.net/8.10.0/video-js.css" rel="stylesheet" />
            <meta property="article:modified_time" content="' . $currentDateCheck . '" />
            <script src="../../css/js/jquery-3.2.1.slim.min.js"></script>
            <script src="../../css/js/boorstrap1.js"></script>
            <script src="../../css/js/boorstrap2.js"></script>
            <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
            <link rel="canonical" href="https://www.filiumenter.com/shopon/blogs/bl' . $fileName . '">
            <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@24,400,0,0" />
            ' . $gac . '
            <style>
                .rbtn button {
                    padding: 0.8rem 1.5rem;
                    background-color: white;
                    font-size: 1.1rem;
                    color: #1c5472;
                    border-radius: 15px;
                    border: #1c5472 2px solid;
                    cursor: pointer;
                    transition: 0.4s ease-in-out all;
                }
                .rbtn button:hover {
                    background-color: #1c5472;
                    color: white;
                }
                footer {
                    margin: 0;
                    padding: 0;
                    width: 100%;
                    min-height: 550px;
                    background-color: #2b343b;
                    overflow: hidden;
                }
                footer .footer {
                    padding: 3rem 0rem;
                    margin: 2rem 7rem;
                    display: grid;
                    grid-template-columns: 1fr 1fr 1fr;
                    grid-gap: 2rem;
                    justify-content: center;
                    justify-self: center;
                }
                @media (max-width: 1100px) {
                    footer .footer {
                        grid-template-columns: 1fr 1fr;
                        padding: 0rem 0rem;
                        margin: 1rem 3rem;
                    }
                }
                @media (max-width: 700px) {
                    footer .footer {
                        grid-template-columns: 1fr;
                    }
                }
                a {
                    text-decoration: none;
                }
            
                .productIndexImg:hover {
                    transform: scale(2.5);
                    overflow: hidden;
                    transition: 0.2s;
                }
            
                .footer-links {
                    color: white;
                    padding: 0;
                    margin: 20px 0 12px;
                }
            
                .footer-links a {
                    color: white;
                    text-decoration: none;
                    font-weight: 400;
                    padding: 10px;
                    line-height: 1.8;
                    border-left: 2px solid white;
                }
            
                .footer-links a:hover {
                    color: blue;
                }
            
                .footer-icons {
                    margin-top: 25px;
                }
            
                .footer-icons a {
                    display: inline-block;
                    width: 35px;
                    height: 35px;
                    cursor: pointer;
                    background: white;
                    border-radius: 5px;
                    font-size: 25px;
                    text-align: center;
                    line-height: 35px;
                    margin-right: 3px;
                    margin-bottom: 5px;
                }
            
                .footer-icons a:hover {
                    background: black;
                    color: white;
                }
                 .sharefloat {
                    position: fixed;
                    width: 60px;
                    height: 60px;
                    bottom: 100px;
                    right: 40px;
                    background-color: #25d366;
                    color: #fff;
                    border-radius: 50px;
                    text-align: center;
                    font-size: 30px;
                    box-shadow: 2px 2px 3px #999;
                    z-index: 100;
                }
                .my-float {
                    margin-top: 16px;
                }
            </style>
        </head>
        <body>
        <div class="modal fade" id="modelId" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-body">
            <div class="row">
              <div class="col-sm-6">
                <h4 class="text-left">Share</h4>
              </div>
              <div class="col-sm-6">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
            </div>
            <hr />
            <div class="row mt-2"></div>
            <div class="col-sm-12" style="display: flex; justify-content: center;">
              <a
                href="https://www.facebook.com/sharer/sharer.php?u=https://www.filiumenter.com/shopon/blogs/' . htmlspecialchars($slink, ENT_QUOTES, 'UTF-8') . '"
                target="_blank"
                class="btn btn-primary mr-4"
                style="text-decoration: none; border-radius: 50%;"
              >
                <i class="fa fa-facebook"></i>
              </a>
              <a
                href="https://api.whatsapp.com/send?text=https://www.filiumenter.com/shopon/blogs/' . htmlspecialchars($slink, ENT_QUOTES, 'UTF-8') . '"
                target="_blank"
                class="btn btn-success mr-4"
                style="text-decoration: none; border-radius: 50%;"
              >
                <i class="fa fa-whatsapp"></i>
              </a>
              <a
                href="https://twitter.com/intent/tweet?url=https://www.filiumenter.com/shopon/blogs/' . htmlspecialchars($slink, ENT_QUOTES, 'UTF-8') . '"
                target="_blank"
                class="btn btn-dark mr-4"
                style="text-decoration: none; border-radius: 50%;"
              >
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-twitter-x" viewBox="0 0 16 16">   <path d="M12.6.75h2.454l-5.36 6.142L16 15.25h-4.937l-3.867-5.07-4.425 5.07H.316l5.733-6.57L0 .75h5.063l3.495 4.633L12.601.75Zm-.86 13.028h1.36L4.323 2.145H2.865z"/> </svg>
              </a>
            </div>
          </div>
          <div class="row m-2 mb-4">
            <div class="col-sm-12">
              <div class="form-inline" style="display: flex; justify-content: center;">
                <input type="text" name="blog_link" class="form-control" id="blog_link" style="width: 80%" readonly />
                <button class="btn btn-secondary ml-1" id="copyLinkBtn" style="border-radius: 33%;">
                  <i class="fa fa-copy"></i>
                </button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <a class="sharefloat" data-toggle="modal" data-target="#modelId">
      <i class="fa fa-share my-float" style="color: white"></i>
    </a>
          <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
                <a class="navbar-brand" href="../../index.php">' . $shopName . '</a>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav mr-auto">
                <li class="nav-item active" >
                    <a class="nav-link" href="../index.php">Blogs</a>
                </li>
                <li class="nav-item active">
                    <a class="nav-link" href="../../submit_customer_requirement.php">Custom / Bulk Pricing</a>
                </li>
                <li class="nav-item active">
                    <a class="nav-link" href="../../user_help_videos.php">User Help & Product Videos</a>
                </li>
                </ul>
                <form class="form-inline my-2 my-lg-0" action="search.php" method="get">
                <input class="form-control mr-sm-2" type="search" name="search" placeholder="Search" aria-label="Search">
                <button class="btn btn-outline-success my-2 my-sm-0" type="submit">Search</button>
                </form>
            </div>
        </nav>
    <div class="container" style="justify-content:center">
        <div class="row">
            <div class="col-sm-12">
                <h1 style="text-align:center;">' .  htmlspecialchars($topic, ENT_QUOTES, 'UTF-8') . '</h1>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">
                <img src="../img/' . $image_name . '" class="img-thumbnail" alt="Blog Image" />
            </div>
        </div><br>
        <div class="row">
            <div class="col-sm-12">
                <span class="text-right"> Published On: ' . $currentDate . '</span>
            </div>
        </div><br>
        <div class="row">
            <div class="col-sm-12">
                ' . $content_html . '
            </div>
        </div>';
    if (!empty($related_product)) {
        $htmlContent .= '<div class="row" style="margin-top:20px;margin-bottom:20px;">
                                <div class="col-sm-12">
                                    <h3>Related Products<h3><hr>
                                </div>
                            </div>
                            <div class="row" style="margin-bottom:20px;">';
        // Use prepared statements to avoid SQL injection
        foreach ($related_product as $j) {
            $intj = intval($j);
            $stmt = $conn->prepare("SELECT * FROM products WHERE id=? ORDER BY RAND()");
            $stmt->bind_param("s", $intj);
            $stmt->execute();
            $resultProduct = $stmt->get_result();
            if ($resultProduct->num_rows > 0) {
                while ($rsp = $resultProduct->fetch_assoc()) {
                    $htmlContent .= '<div class="col-sm-4" style="display:flex;flex-direction:column;">
                                    <a href="../../details.php?product_id=' . $rsp["id"] . '" style="color:black" target="_blank">';
                    if ($rsp["product_img"] != null) {
                        $image = $rsp["product_img"];
                    } else {
                        $image = "no-image-placeholder.png";
                    }
                    $htmlContent .= '<img src="../../admin/connection/product_images/' . $image . '" style="object-fit: contain;height:40vh " class="img-fluid">
                                    <h6 style="text-align:center">' . $rsp["product_name"] . '</h6>
                                    </a>
                                    <a class="btn btn-success" href="../../details.php?product_id=' . $rsp["id"] . '" style="font-weight:bold" >Buy Now</a>
                                </div>';
                }
            }
        }
        $stmt->close();
        $htmlContent .= '</div><hr>';
    }
    $htmlContent .= ' 
        <div class="row mt-1">
            <div class="col-sm-12">
                <h3>Related Blogs<h3><hr>
            </div>
        </div>
        <div class="row mt-1">';
    foreach ($related_blogs as $i) {
        $int = intval($i);
        $selects = "SELECT * FROM blog WHERE id = $int";
        $results = mysqli_query($conn, $selects);

        while ($rows = mysqli_fetch_array($results)) {
            $index123 += 1;
            $htmlContent .= '<div class="col-sm-3 mt-2" style="display:flex;flex-direction:column;">
                                    <a href="../' . $rows['link'] . '" style="color:black;text-decoration:none;" target="_blank">
                                        <img src="../img/' . $rows['img'] . '" style="display:block;height:24vh" class="img-fluid">
                                        <h6 style="text-align:center" style="overflow: hidden; white-space: nowrap; text-overflow: ellipsis; display: block;margin-top:3px ">' . $rows["title"] . '</h6>
                                    </a>
                                </div>';
        }
    }
    $sql_footer = "SELECT * FROM footer";
    $result_footer = mysqli_query($conn, $sql_footer);
    $rowf = mysqli_fetch_array($result_footer);
    $htmlContent .= '
            </div>
        </div>
        <div class="container-fluid mt-4" style="background-color:black;color:white;justify-content:space-between;padding:30px">
                <div class="row">
                    <div class="col-sm-4">
                        <div class="row">
                            <div class="col-sm-12">
                                <h2 style="text-align:center;">' . $shopName . '</h2>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <p class="footer-links">
                                    <a href="https://www.' . $domain . '/about_us.php" style="border:none;text-decoration:none;color:white;">' . $rowf['about_us'] . '</a>
                                    <a href="https://www.' . $domain . '/contact_us.php" style="text-decoration:none;color:white;" >' . $rowf['contact_us'] . '</a>
                                    <a href="https://www.' . $domain . '/terms_and_conditions.php" style="text-decoration:none;color:white;">' . $rowf['our_vision'] . '</a>
                                </p>
                            </div>
                        </div>
                    </div>
                     <div class="col-sm-4 blue align-items-center">
                        <div class="row">
                            <div class="col-sm-12">
                                <h3 class="text-center">' . $rowf['important_links'] . '</h3>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12 justify-content-center" style="display:flex;flex-direction:column;justify-content:center;align-items:center">
                                <p>';
    if (!isset($_SESSION['adminemail'])) {
        $htmlContent .= '<a href="https://www.' . $domain . '/admin/admin_login_page.php" style="text-decoration:none;color:white">Admin</a>';
    }
    $htmlContent .= '</p>
                                <p>';
    if (!isset($_SESSION['suplierEmail'])) {
        $htmlContent .= '<a href="https://www.' . $domain . '/admin/supplier_login.php" style="text-decoration:none;color:white">Supplier</a>';
    }
    $htmlContent .= '</p>
                            </div>
                        </div>
                        <!--<p><a href="/shopon/admin/suplier_signup.php" style="text-decoration:none;color:white">Supplier Sign Up</a></p>-->
    
                    </div>
    
                    <div class="col-sm-4 blue about_us_section" style="display:flex;flex-direction:column;justify-content:center;align-items:center">
                        <div class="row">
                            <div class="col-sm-12">
                                <b class="text-center"><a href="about_us.php" class="aboutLink" style="color:white;text-decoration:none">' . $rowf['about_us_title'] . '</a></b>
                                <br>
                                <p class="about_us_body">' . $rowf['about_us_body'] . '</p>
                            </div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="footer-icons">
                                    <a href="https://' . $rowf['facebook'] . '"><i class="fa fa-facebook"></i></a>
                                    <a href="https://' . $rowf['instagram'] . '"><i class="fa fa-instagram"></i></a>
                                    <a href="https://' . $rowf['twitter'] . '"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-twitter-x" viewBox="0 0 16 16">   <path d="M12.6.75h2.454l-5.36 6.142L16 15.25h-4.937l-3.867-5.07-4.425 5.07H.316l5.733-6.57L0 .75h5.063l3.495 4.633L12.601.75Zm-.86 13.028h1.36L4.323 2.145H2.865z"/> </svg></a>
                                    <a href="https://' . $rowf['youTube'] . '"><i class="fa fa-youtube"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <script>
      // Set the link in the input field
      document.getElementById("blog_link").value = window.location.href;

      // Copy link to clipboard
      document.getElementById("copyLinkBtn").addEventListener("click", function () {
        const copyText = document.getElementById("blog_link");
        copyText.select();
        document.execCommand("copy");
        alert("Link copied to clipboard!");
      });
    </script>
        <script src="app.js"></script>
        <script src="../../css/js/jquery-3.2.1.slim.min.js"></script>
        <script src="https://vjs.zencdn.net/8.10.0/video.min.js"></script>
        </body>
            </html>';
  

    $dirPath = dirname($filePath);
    if (!is_dir($dirPath)) {
        if (!mkdir($dirPath, 0777, true)) {
            echo "Failed to create directories!";
            exit;
        }
    }

    // Step 2: Create the file if it doesn't exist
    if (!file_exists($filePath)) {
        $file = fopen($filePath, "w");
        if ($file === false) {
            echo "Failed to create the file!";
            exit;
        }
        fclose($file);
    }
    $topic_check = mysqli_real_escape_string($conn, $topic);

    $already_blog = mysqli_query($conn, "SELECT `id` FROM `blog` WHERE `title`='$topic_check'");
    if (mysqli_num_rows($already_blog)) {
        echo "Blog Already present";
        exit;
    } else {
        // Update the database
        if (file_put_contents($filePath, $htmlContent)) {
            $updateNlogTopic = mysqli_query($conn, "UPDATE `blog_topics` SET `generated`='1' WHERE `id`=$id");

            $insertBlog = mysqli_query($conn, "INSERT INTO `blog` (`title`, `content`, `img`, `link`, `descriptions`, `tags`, `relatedlinks`, `related_product`) 
            VALUES (
                '" . mysqli_real_escape_string($conn, $topic) . "',
                '" . mysqli_real_escape_string($conn, $content_html) . "',
                '" . mysqli_real_escape_string($conn, $image_name) . "',
                '" . mysqli_real_escape_string($conn, $slink) . "',
                '" . mysqli_real_escape_string($conn, $description_html) . "',
                '" . mysqli_real_escape_string($conn, $tags) . "',
                '" . mysqli_real_escape_string($conn, json_encode($related_blogs)) . "',
                '" . mysqli_real_escape_string($conn, json_encode($related_product)) . "'
            )");
            if ($insertBlog) {
                echo '<h3>Blog Published Successfully</h3>';
                exit;
            }
        } else {
            echo "Error creating the HTML file!";
        }
    }
} else {
    echo "<h3>No unprocessed blog topics found.</h3>";
}

// === FUNCTIONS ===

function generateAI($prompt)
{
    // Try to get an unused API key
    $conn = new mysqli('localhost', 'filiumen_ter', 'filiumenter0939!', 'filiumen_ecommerce');
    $conn->set_charset('utf8mb4');
    $apiKey = "";
    $fetchApiKey = mysqli_query($conn, "SELECT `apiKey` FROM `deepseek_keys` WHERE `used`=0 LIMIT 1");

    if (mysqli_num_rows($fetchApiKey)) {

        $apiResult = mysqli_fetch_assoc($fetchApiKey);
        $apiKey = $apiResult['apiKey'];

        // Mark this key as used
        mysqli_query($conn, "UPDATE `deepseek_keys` SET `used`=1 WHERE `apiKey`='$apiKey'");
    } else {
        // All keys have been used. Reset all to unused (except this time's use)
        mysqli_query($conn, "UPDATE `deepseek_keys` SET `used`=0");

        // Fetch one again
        $fetchApiKey = mysqli_query($conn, "SELECT `apiKey` FROM `deepseek_keys` LIMIT 1");
        $apiResult = mysqli_fetch_assoc($fetchApiKey);
        $apiKey = $apiResult['apiKey'];

        // Mark it as used
        mysqli_query($conn, "UPDATE `deepseek_keys` SET `used`=1 WHERE `apiKey`='$apiKey'");
    }


    $url = 'https://openrouter.ai/api/v1/chat/completions';

    $data = [
        'model' => 'deepseek/deepseek-r1:free',
        'messages' => [
            ['role' => 'user', 'content' => $prompt]
        ]
    ];

    $headers = [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $apiKey
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $response = curl_exec($ch);
    curl_close($ch);

    $result = json_decode($response, true);
    return $result['choices'][0]['message']['content'] ?? 'Error: No content returned.';
}

function cleanText($text)
{
    $text = htmlspecialchars_decode($text); // decode & keep markdown
    // Remove AI boilerplate or extra headers
    $text = preg_replace('/^(Here (is|are)|Keywords:|Word count:|Description:|Formatted.*:)\s*/i', '', $text);
    $text = preg_replace('/(?i)\*?By\s+\[.*?\]\*?/', '', $text); // remove author lines
    $text = preg_replace('/(?i)\*?Word count:.*$/m', '', $text); // remove word count lines
    return trim($text);
}


function cleanTags($text)
{
    $text = strip_tags($text);
    $text = htmlspecialchars_decode($text);
    $text = preg_replace('/^(keywords:|here are|formatted.*:)?\s*/i', '', $text);
    return trim($text);
}
