<?php
include('./config.php');

$sitemap_filepath = "/home/eprofitify/public_html/sitemap.xml";

// Load the existing sitemap
$dom = new DOMDocument();
$dom->preserveWhiteSpace = false;
$dom->formatOutput = true;
$dom->load($sitemap_filepath);

$xpath = new DOMXPath($dom);
$xpath->registerNamespace('sm', 'http://www.sitemaps.org/schemas/sitemap/0.9');

// Collect all existing <loc> values
$existing_urls = [];
$loc_nodes = $xpath->query('//sm:url/sm:loc');

foreach ($loc_nodes as $loc) {
    $existing_urls[] = trim($loc->nodeValue);
}

// Query all blogs from the database
$blogs_query = mysqli_query($conn, "SELECT `link`, `created_at` FROM `blog`");

if (mysqli_num_rows($blogs_query)) {
    while ($blog = mysqli_fetch_assoc($blogs_query)) {
        $blog_link = 'https://www.eprofitify.com/blogs/' . $blog['link'];
        $blog_created_at = date('Y-m-d', strtotime($blog['created_at']));

        // Add to sitemap only if not already present
        if (!in_array($blog_link, $existing_urls)) {
            // Create <url> element and its children
            $url = $dom->createElement('url');

            $loc = $dom->createElement('loc', htmlspecialchars($blog_link));
            $lastmod = $dom->createElement('lastmod', $blog_created_at);
            $changefreq = $dom->createElement('changefreq', 'monthly');
            $priority = $dom->createElement('priority', '0.8');

            $url->appendChild($loc);
            $url->appendChild($lastmod);
            $url->appendChild($changefreq);
            $url->appendChild($priority);

            // Append the <url> element to the root <urlset>
            $dom->documentElement->appendChild($url);
        }
    }

    // Save the updated sitemap with proper formatting
    $dom->save($sitemap_filepath);
}
?>
